
set more off
use "JEAS 2021.dta", replace

*===============================================================
* Sample Characteristics
*===============================================================
log using "Table-A1.log", replace
tab female
tab religion
tab agecat
tab edu
log close

drop if religion != 1

*===============================================================
* Original and Effective Group Size
*===============================================================
tab group
tab group if dvexp < 3


*===============================================================
* T-Test in the Order of the Paper (Page 11)
*===============================================================

log using "T-Test.log", replace

* religion v control
ttest dvexp if inlist(group,0,2), by(group)

* ethnicity v control
ttest dvexp if inlist(group,0,1), by(group)

* ethnicity-religion v religion
ttest dvexp if inlist(group,2,3), by(group)

* general linear test
reg dvexp i.group
test 1.group - 0.group == 3.group - 2.group

* ulema v control
ttest dvexp if inlist(group,0,4), by(group)

log close


*===============================================================
* Regressions: Basic (Figure 1 and Appendix A4)
*===============================================================

set more off
logit dvexp i.group
estimates store m1
margins group
marginsplot, recast(bar) graphregion(color(white)) ///
				xtitle(Experimental Group, tstyle(size(medsmall))) ytitle(Probability(Vote Ahok), tstyle(size(medsmall))) ///
				plotopts(barwidth(0.75) fcolor(*.2)) yscale(range(0 .5)) ylabel(.1(.1).5) xscale(range(0 4.5)) ///
				xlabel(,labsize(small)) yscale(titlegap(*1)) xscale(titlegap(*2)) ///
				title("") name(basic)
graph export "Figure-1.png", replace

esttab m* using Table-A4.csv, b(3) se(2) starlevels(* .10 ** .05 *** .01) r2(3) nogaps replace
estimates clear


*===============================================================
* Regressions: Conditional with Interaction (Tables A5, A9)
*===============================================================

*********** by satisfaction *******************
set more off
logit dvexp i.group##c.satisfaction
estimates store m1

******************* by shalat *******************
set more off
logit dvexp i.group##c.shalat
estimates store m2

*********** by tolerance *******************
set more off
logit dvexp i.group##c.tolelected
estimates store m3

*********** by islamiclaw *******************
set more off
logit dvexp i.group##c.islamiclaw
estimates store m4

*********** by knowledge *******************
set more off
logit dvexp i.group##i.pilgubknowledge
estimates store m7

*********** by income *******************
set more off
logit dvexp i.group##c.income
estimates store m8

esttab m1 m2 m3 m4 using Table-A5.csv, b(3) se(2) starlevels(* .10 ** .05 *** .01) r2(3) nogaps replace
esttab m7 m8 using Table-A9.csv, b(3) se(2) starlevels(* .10 ** .05 *** .01) r2(3) nogaps replace
estimates clear


*===============================================================
* Plotting: Conditional with Interaction (Figure 3)
*===============================================================


*********** by satisfaction *******************
set more off
logit dvexp i.group##c.satisfaction
margins, at(group=(0 (1) 4) satisfaction=(2.15)) post
estimates store low

set more off
logit dvexp i.group##c.satisfaction
margins, at(group=(0 (1) 4) satisfaction=(3.43)) post
estimates store high

coefplot (low, color(gray)) ///
		 (high, color(olive_teal)), ///
		 ytitle(Probability(Vote Ahok), tstyle(size(medsmall))) ///
		 vertical recast(bar) barwidth(0.25) ciopts(recast(rcap)) citop ///
		legend(rows(1) label(1 "Low Satisfaction") label(3 "High Satisfaction") tstyle(size(small))) ///
		graphregion(color(white)) xscale(range(1 5)) ///
		xlabel(1 "Control" 2 "Ethnicity" 3 "Religion" 4 "Ethnicity & Religion" 5 "Ulema") ///
		xlabel(,labsize(small)) bgcolor(white) ///
		yscale(titlegap(*1))  xscale(titlegap(*2)) ///
		subtitle(Predicted Support by Satisfaction, tstyle(size(small))) ///
		name(satisfaction)
graph export "Figure-3-Satisfaction.png", replace

log using "Figure-3-Marginal-Satisfaction.log", replace
set more off
logit dvexp i.group##c.satisfaction
margins, dydx(group) at(satisfaction=2.15)
margins, dydx(group) at(satisfaction=3.43)

set more off
logit dvexp ib3.group##c.satisfaction
margins, dydx(group) at(satisfaction=2.15)
margins, dydx(group) at(satisfaction=3.43)
log close



******************* by shalat *******************
set more off
logit dvexp i.group##c.shalat
margins, at(group=(0 (1) 4) shalat=(3.2)) post
estimates store low

set more off
logit dvexp i.group##c.shalat
margins, at(group=(0 (1) 4) shalat=(5)) post
estimates store high

coefplot (low, color(gray)) ///
		 (high, color(olive_teal)), ///
		 ytitle(Probability(Vote Ahok), tstyle(size(medsmall))) ///
		 vertical recast(bar) barwidth(0.25) ciopts(recast(rcap)) citop ///
		legend(rows(1) label(1 "Low Religiosity") label(3 "High Religiosity") tstyle(size(small))) ///
		graphregion(color(white)) xscale(range(1 5)) ///
		xlabel(1 "Control" 2 "Ethnicity" 3 "Religion" 4 "Ethnicity & Religion" 5 "Ulema") ///
		xlabel(,labsize(small)) bgcolor(white) ///
		yscale(titlegap(*1))  xscale(titlegap(*2)) ///
		subtitle(Predicted Support by Religiosity, tstyle(size(small))) ///
		name(shalat)
graph export "Figure-3-Religiosity.png", replace

log using "Figure-3-Marginal-Religiosity.log", replace
set more off
logit dvexp i.group##c.shalat
margins, dydx(group) at(shalat=3.2)
margins, dydx(group) at(shalat=5)

set more off
logit dvexp ib3.group##c.shalat
margins, dydx(group) at(shalat=3.2)
margins, dydx(group) at(shalat=5)
log close



*********** by tolerance *******************
set more off
logit dvexp i.group##c.tolelected
margins, at(group=(0 (1) 4) tolelected=(1.73)) post
estimates store low

set more off
logit dvexp i.group##c.tolelected
margins, at(group=(0 (1) 4) tolelected=(3.08)) post
estimates store high

coefplot (low, color(gray)) ///
		 (high, color(olive_teal)), ///
		 ytitle(Probability(Vote Ahok), tstyle(size(medsmall))) ///
		 vertical recast(bar) barwidth(0.25) ciopts(recast(rcap)) citop ///
		legend(rows(1) label(1 "Low Tolerance") label(3 "High Tolerance") tstyle(size(small))) ///
		graphregion(color(white)) xscale(range(1 5)) ///
		xlabel(1 "Control" 2 "Ethnicity" 3 "Religion" 4 "Ethnicity & Religion" 5 "Ulema") ///
		xlabel(,labsize(small)) bgcolor(white) ///
		yscale(titlegap(*1))  xscale(titlegap(*2)) ///
		subtitle(Predicted Support by Religious Tolerance, tstyle(size(small))) ///
		name(tolerance)
graph export "Figure-3-Tolerance.png", replace

log using "Figure-3-Marginal-Tolerance.log", replace
set more off
logit dvexp i.group##c.tolelected
margins, dydx(group) at(tolelected=1.73)
margins, dydx(group) at(tolelected=3.08)

set more off
logit dvexp ib3.group##c.tolelected
margins, dydx(group) at(tolelected=1.73)
margins, dydx(group) at(tolelected=3.08)
log close


		
*********** by islamic law *******************
set more off
logit dvexp i.group##c.islamiclaw
margins, at(group=(0 (1) 4) islamiclaw=(1.99)) post
estimates store low

set more off
logit dvexp i.group##c.islamiclaw
margins, at(group=(0 (1) 4) islamiclaw=(3.41)) post
estimates store high

coefplot (low, color(gray)) ///
		 (high, color(olive_teal)), ///
		 ytitle(Probability(Vote Ahok), tstyle(size(medsmall))) ///
		 vertical recast(bar) barwidth(0.25) ciopts(recast(rcap)) citop ///
		legend(rows(1) label(1 "Low Support for Sharia") label(3 "High Support for Sharia") tstyle(size(small))) ///
		graphregion(color(white)) xscale(range(1 5)) ///
		xlabel(1 "Control" 2 "Ethnicity" 3 "Religion" 4 "Ethnicity & Religion" 5 "Ulema") ///
		xlabel(,labsize(small)) bgcolor(white) ///
		yscale(titlegap(*1))  xscale(titlegap(*2)) ///
		subtitle(Predicted Support by Support for Sharia, tstyle(size(small))) ///
		name(sharia)
graph export "Figure-3-Sharia.png", replace

log using "Figure-3-Marginal-Sharia.log", replace
set more off
logit dvexp i.group##c.islamiclaw
margins, dydx(group) at(islamiclaw=1.99)
margins, dydx(group) at(islamiclaw=3.41)

set more off
logit dvexp ib3.group##c.islamiclaw
margins, dydx(group) at(islamiclaw=1.99)
margins, dydx(group) at(islamiclaw=3.41)
log close


*********** by pilgub knowledge *******************
set more off
logit dvexp i.group##i.pilgubknowledge
margins, at(group=(0 (1) 4) pilgubknowledge=(0)) post
estimates store low

set more off
logit dvexp i.group##i.pilgubknowledge
margins, at(group=(0 (1) 4) pilgubknowledge=(1)) post
estimates store high

coefplot (low, color(gray)) ///
		 (high, color(olive_teal)), ///
		 ytitle(Probability(Vote Ahok), tstyle(size(medsmall))) ///
		 vertical recast(bar) barwidth(0.25) ciopts(recast(rcap)) citop ///
		legend(rows(1) label(1 "Low Knowledge") label(3 "High Knowledge") tstyle(size(small))) ///
		graphregion(color(white)) xscale(range(1 5)) ///
		xlabel(1 "Control" 2 "Ethnicity" 3 "Religion" 4 "Ethnicity & Religion" 5 "Ulema") ///
		xlabel(,labsize(small)) bgcolor(white) ///
		yscale(titlegap(*1))  xscale(titlegap(*2)) ///
		subtitle(Predicted Support by Knowledge about Election, tstyle(size(small))) ///
		name(knowledge)
graph export "Figure-A9-Knowledge.png", replace

log using "Figure-A9-Marginal-Knowledge.log", replace
set more off
logit dvexp i.group##i.pilgubknowledge
margins, dydx(group) at(pilgubknowledge=0)
margins, dydx(group) at(pilgubknowledge=1)

set more off
logit dvexp ib3.group##i.pilgubknowledge
margins, dydx(group) at(pilgubknowledge=0)
margins, dydx(group) at(pilgubknowledge=1)
log close


*********** by income *******************
set more off
logit dvexp i.group##c.income
margins, at(group=(0 (1) 4) income=(1.558)) post
estimates store low

set more off
logit dvexp i.group##c.income
margins, at(group=(0 (1) 4) income=(6.248)) post
estimates store high

coefplot (low, color(gray)) ///
		 (high, color(olive_teal)), ///
		 ytitle(Probability(Vote Ahok), tstyle(size(medsmall))) ///
		 vertical recast(bar) barwidth(0.25) ciopts(recast(rcap)) citop ///
		legend(rows(1) label(1 "Low Income") label(3 "High Income") tstyle(size(small))) ///
		graphregion(color(white)) xscale(range(1 5)) ///
		xlabel(1 "Control" 2 "Ethnicity" 3 "Religion" 4 "Ethnicity & Religion" 5 "Ulema") ///
		xlabel(,labsize(small)) bgcolor(white) ///
		yscale(titlegap(*1))  xscale(titlegap(*2)) ///
		subtitle(Predicted Support by Income, tstyle(size(small))) ///
		name(income)
graph export "Figure-A9-Income.png", replace

log using "Figure-A9-Marginal-Income.log", replace
set more off
logit dvexp i.group##c.income
margins, dydx(group) at(income=1.558)
margins, dydx(group) at(income=6.248)

set more off
logit dvexp ib3.group##c.income
margins, dydx(group) at(income=1.558)
margins, dydx(group) at(income=6.248)
log close

graph drop basic satisfaction shalat tolerance sharia knowledge income

		
*===============================================================
* Covariate Balance (Table A3)
*===============================================================
log using "Table-A3-Original-Sample.log", replace
anova female group
anova age group
anova edu group
anova income group
anova pilgubknowledge group
anova satisfaction group
anova feelchristian group
anova feeltionghoa group
anova shalat group
anova tolelected group
anova islamiclaw group
log close

log using "Table-A3-Effective-Sample.log", replace
anova female group if dvexp < 3
anova age group if dvexp < 3 
anova edu group if dvexp < 3
anova income group if dvexp < 3
anova pilgubknowledge group if dvexp < 3
anova satisfaction group if dvexp < 3
anova feelchristian group if dvexp < 3
anova feeltionghoa group if dvexp < 3
anova shalat group if dvexp < 3
anova tolelected group if dvexp < 3
anova islamiclaw group if dvexp < 3
log close


*===============================================================
* Regressions: DV = Whether Part of Effective (Appendix A8)
*===============================================================
set more off
gen effective = 0
replace effective = 1 if dvexp < 3

logit effective i.group
estimates store m1

margins group
marginsplot, recast(bar) graphregion(color(white)) ///
				xtitle(Experimental Group, tstyle(size(medsmall))) ytitle(Probability(Effective Sample), tstyle(size(medsmall))) ///
				plotopts(barwidth(0.75) fcolor(*.2)) yscale(range(0 .8)) ylabel(.1(.1).8) xscale(range(0 4.5)) ///
				xlabel(,labsize(small)) yscale(titlegap(*1)) xscale(titlegap(*2)) ///
				title("")
graph export "Figure-A8.png", replace

esttab m* using Table-A8.csv, b(3) se(2) starlevels(* .10 ** .05 *** .01) r2(3) nogaps replace
estimates clear

